﻿using UnityEngine;
using System.Collections;

public class Rotate : MonoBehaviour {
	//private float rotateSpeed = 20.0f;
	private int rotationDirection = -1; // -1 for clockwise
	//  1 for anti-clockwise
	
	private int rotationStep = 3;    // should be less than 90
	public GameObject[] objectsArray;
	private bool isRotating = false;
	private Vector3 currentRotation, targetRotation;
	public StepSequencer2 stepSequencer2;
	public int step = 0;
	//private float rotateSpeed = 180.0f;

	// Use this for initialization
	void Start () {
	//	string myTag = gameObject.transform.name
	}
	
	// Update is called once per frame
	void Update () {
		if(stepSequencer2.flip == step && isRotating == false)		{RotateCube();}
		else if(stepSequencer2.flip != step && isRotating == true) 	{isRotating = false;}

	}
	private void RotateCube(){
		isRotating = true;
		currentRotation = gameObject.transform.eulerAngles;
		targetRotation.z = (currentRotation.z + (90 * rotationDirection));
		StartCoroutine (objectRotationAnimation());
	}
	IEnumerator objectRotationAnimation()
	{
		// add rotation step to current rotation.
		currentRotation.z += (rotationStep * rotationDirection);
		gameObject.transform.eulerAngles = currentRotation;
		
		yield return new WaitForSeconds (0);
		
		if (((int)currentRotation.z >
		     (int)targetRotation.z && rotationDirection < 0)  ||  // for clockwise
		    ((int)currentRotation.z <  (int)targetRotation.z && rotationDirection > 0)) // for anti-clockwise
		{
			StartCoroutine (objectRotationAnimation());
		}
		else
		{
			gameObject.transform.eulerAngles = targetRotation;
		}
	}
	IEnumerator rotateObjectAgain()
	{
		yield return new WaitForSeconds (0.2f);
		//CheckSky();
	}
}
