﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class MoveCameraForMenu : Photon.MonoBehaviour {
	private float startX = -3.8f;
	private float startY = 26.8f;
	private float startZ = -4.1f;
	private float endX = 4f;
	private float endY = 22.6f;
	private float endZ = -5.6f;

	private bool menuChange = true;

	private bool hasConnected = false;
	public UnityEngine.UI.Toggle menuOn;


	// Use this for initialization
	void Start () {
		menuOn = GameObject.Find ("ToggleMenu").GetComponent<UnityEngine.UI.Toggle>();

	}

	void OnJoinedRoom() {
		hasConnected = true;
	}
	//void OnGUI()
	//{
	//	if (hasConnected == true) {
	//		GUILayout.Label (PhotonNetwork.playerList.Length + " users are online");
	//	}
	//}
	// Update is called once per frame
	void Update () {
		if (menuChange != menuOn.isOn && hasConnected == true) {
			if (menuOn.isOn == true) {
				StartCoroutine(MenuOn(new Vector3(endX, endY, endZ), new Vector3(startX, startY, startZ)));
				menuChange = menuOn.isOn;
			} else {

				StartCoroutine(MenuOn(new Vector3(startX, startY, startZ), new Vector3(endX, endY, endZ)));
				menuChange = menuOn.isOn;
			}
		}
	}
	IEnumerator MenuOn(Vector3 startPosition, Vector3 newPosition) {

		float i = 0.0f;
		while (i < 1.0f) {
			transform.position = Vector3.Lerp(startPosition, newPosition, Mathf.SmoothStep(0,1,i));
			i += Time.deltaTime;
			yield return 0;
		}
	}
}