﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class ModeManager : Photon.MonoBehaviour {
	public UnityEngine.UI.Toggle toggleMode1;
	public UnityEngine.UI.Toggle toggleMode2;
	public UnityEngine.UI.Text dataText;
	public bool mode;
	public bool hasConnected = false;
	private string actorID;
	private int slightDelayOnMode = 0;

	
	// Use this for initialization
	void Start () {
		toggleMode1 = GameObject.Find ("ToggleMode1").GetComponent<UnityEngine.UI.Toggle>();
		toggleMode2 = GameObject.Find ("ToggleMode2").GetComponent<UnityEngine.UI.Toggle>();
	}
	void OnJoinedRoom() {
		hasConnected = true;
		actorID = GameObject.Find("NetworkManager").GetComponent<NetworkManagerPhoton>().actorID;
		dataText = GameObject.Find ("DataText").GetComponent<UnityEngine.UI.Text>();
	}	
	// Update is called once per frame
	void Update () {
		if (hasConnected == true && slightDelayOnMode < 20) {
			slightDelayOnMode++;
			mode = toggleMode1.isOn;
		}
		if (mode != toggleMode1.isOn && hasConnected == true && slightDelayOnMode >=20) {
				if (toggleMode1.isOn == true) {
					mode = toggleMode1.isOn;
				} else {
					mode = toggleMode1.isOn;
				}
				photonView.RPC ("SyncMode", PhotonTargets.All, actorID, toggleMode1.isOn, toggleMode2.isOn, mode);
			} 
	}

[RPC] void SyncMode(string ID, bool mode1, bool mode2, bool currentMode) //Server forcing all clients to syncronyze modes
	{
		GameObject.Find("ToggleMode1").GetComponent<Toggle>().isOn = mode1;
		GameObject.Find("ToggleMode2").GetComponent<Toggle>().isOn = mode2;
		mode = currentMode;
		Debug.Log (photonView.name + ", Mode1 " + mode1 + ", Mode2 " + mode2 + ", " + ID + ", " + PhotonNetwork.playerList.Length + ", " + System.DateTime.Now.ToString());
		if (mode1 == true) {
			dataText.text = "Anonymous " + ID + " changed the sequencer to Mode 1";
		} else {
			dataText.text = "Anonymous " + ID + " changed the sequencer to Mode 2";
		}
		//photonView.RPC ("SyncMode", PhotonTargets.Others,  mode1, mode2, currentMode);	
	}
}
